<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 19.12.13 11:44
 */
namespace VM\FinancialStatementsBundle\Tests\Services;

use VM\FinancialStatementsBundle\Services\DataStructure\FinansowanieInwestycjiDS;
use VM\FinancialStatementsBundle\Services\FinansowanieInwestycji;

class FinansowanieInwetycjiTest extends \PHPUnit_Framework_TestCase
{
    public function testDefaultDSReturnException()
    {
        try
        {
            $FinInvDS = new FinansowanieInwestycjiDS();
            $validate = $FinInvDS->validate();
        }
        catch(\Exception $e)
        {
            $this->assertTrue(true);
        }
    }


    public function testDSVersion1()
    {
        try
        {
            $FinInvDS = new FinansowanieInwestycjiDS();
            $FinInvDS->naklady = 2000;
            $FinInvDS->procentAmortyzacji = 0.1;
            $FinInvDS->rokPoczatkowy = 2013;
            $FinInvDS->liczbaLat = 8;
            $FinInvDS->czyKapitalWlasny = true;
            $FinInvDS->czyKredyt = true;
            $FinInvDS->czyLeasing = false;
            $FinInvDS->czyNaSrodkiTrwale = true;
            $FinInvDS->kapitalWlasny = 1000;
            $FinInvDS->kapitalObcy = 1000;
            $FinInvDS->oprocentowanieKredytuLubLeasingu = 0.05;
            $FinInvDS->okresKredytuLubLeasingu = 5;
            $FinInvDS->ostatniaWplataLeasingu = 0;


            $FinansowanieInwestycji = FinansowanieInwestycji::create($FinInvDS);
            $Podsumowanie = $FinansowanieInwestycji->getResultsOf('Podsumowanie');
            $Kredyt = $FinansowanieInwestycji->getResultsOf('Kredyt');
            $Leasing = $FinansowanieInwestycji->getResultsOf('Leasing');
            $Amortyzacja = $FinansowanieInwestycji->getResultsOf('Amortyzacja');


            $this->assertEquals($Podsumowanie->zmianaKapitaluObcegoNaRokPoczatkowy, 1000);
            $this->assertEquals($Podsumowanie->zmianaKapitaluWlasnego, 1000);
            $this->checkArray($Podsumowanie->zmianaKapitaluObcegoNaRok, array(-180.97, -190.02, -199.52, -209.50, -219.98, 0, 0, 0));
            $this->checkArray($Podsumowanie->kosztFinansowyNaRok, array(-50, -40.95, -31.45, -21.47, -11, 0, 0, 0));

            $this->checkArray($Kredyt->oprocentowanieRoczneKwotaNaRok, array(-50, -40.95, -31.45, -21.47, -11, 0, 0, 0));
            $this->assertEquals($Kredyt->okres, 5);
            $this->assertEquals($Kredyt->kapitalZmianaNaRokPoczatkowy, 1000);
            $this->checkArray($Kredyt->kapitalZmianaNaRok, array(-180.97, -190.02, -199.52, -209.50, -219.98, 0, 0, 0));
            $this->assertEquals($Kredyt->stanKoncowyNaRokPoczatkowy, 1000);
            $this->checkArray($Kredyt->stanKoncowyNaRok, array(819.03, 629, 429.48, 219.98, 0, 0, 0, 0));
            $this->checkArray($Kredyt->rataNaRok, array(-230.97, -230.97, -230.97, -230.97, -230.97, 0, 0, 0));

            $this->assertEquals($Leasing->oprocentowanieRoczne, 0.05);
            $this->checkArray($Leasing->oprocentowanieRoczneKwotaNaRok, array(-100, -81.90, -62.90, -42.95, -22, 0, 0, 0));
            $this->assertEquals($Leasing->okres, 5);
            $this->checkArray($Leasing->kapitalNaRok, array(-361.95, -380.05, -399.05, -419, -439.95, 0, 0, 0 ));
            $this->checkArray($Leasing->rataLeasingowaNaRok, array(-461.95, -461.95, -461.95, -461.95, -461.95, 0, 0, 0 ));
            $this->assertEquals($Leasing->ostatniaWplata, 0);
            $this->checkArray($Leasing->ostatniaWplataNaRok, array(0, 0, 0, 0, 0, 0, 0, 0));

            $this->assertEquals($Amortyzacja->naklady, 2000);
            $this->assertEquals($Amortyzacja->procentAmortyzacji, 0.1);
            $this->assertEquals($Amortyzacja->wartoscPoczatkowaNaRokPoczatkowy, 2000);
            $this->checkArray($Amortyzacja->wartoscPoczatkowaNaRok, array(2000, 1800, 1600, 1400, 1200, 1000, 800, 600));
            $this->assertEquals($Amortyzacja->amortyzacjaNaRokPoczatkowy, 0);
            $this->checkArray($Amortyzacja->amortyzacjaNaRok, array(200, 200, 200, 200, 200, 200, 200, 200));
            $this->assertEquals($Amortyzacja->wartoscKoncowaNaRokPoczatkowy, 2000);
            $this->checkArray($Amortyzacja->wartoscKoncowaNaRok, array(1800, 1600, 1400, 1200, 1000, 800, 600, 400));



        }
        catch(\Exception $e)
        {
            $this->fail($e->getMessage());
        }
    }



    protected function checkArray($calculateValues, $expectedValues)
    {
        $this->assertEquals(count($calculateValues), count($expectedValues));
        foreach(array_values($calculateValues) as $i => $val)
        {
            $this->assertEquals(round($val, 2), $expectedValues[$i]);
        }
    }
}